%% Script to read in multiple activity instances and magnitudes and transform
% to the required system and save them as a csv file.
%
% Alisdair R MacLeod
% Bath University, 2017
%
% Required Variables:
% Ivecs (for each instance)
% Imags (for each instance)
% timepoints (to order and identify the instances)
% trans (transformation matrix)
% Heights_Weights.mat (required for scaling to the relevant patient)
%
BasePath = pwd;
% for all cases modify... for PatN=[1,2,3 ... 30];
%
for PatN=[28];
    %
    DirName = sprintf('/P%d/',PatN);
    %
    cd (fullfile(BasePath,DirName))
    %
    load Imag_15
    load Imag_28
    load Imag_44
    load Imag_63
    load Imag_96
    load Ivecs_15
    load Ivecs_28
    load Ivecs_44
    load Ivecs_63
    load Ivecs_96
    load timepoints
    load Heights_Weights
    load timepoints
    load trans
    %
    for gait_point = 1:1:5
        % get current iteration values
        str=['Ivecs=Ivecs_',num2str(timepoints(gait_point)),';'];
        eval(str);
        str=['Imag=Imag_',num2str(timepoints(gait_point)),';'];
        eval(str);
        %% Mirror the vectors in the X direction (to correct source data)
        IvecsMir=Ivecs;
        IvecsMir(:,1)=IvecsMir(:,1)*-1;
        %
        %% Get the transformed vectors
        tibmusclevecs=TransFunRotOnly(IvecsMir,trans);
        %
        opensim_weight=65.0; %(Gil Serrancoli, paper age 88, height 166cm)
        weight_factor=heights_cm_weights_kg(PatN,2)/opensim_weight;
        %
        for n=1:1:21
            strx=['tibtransmusvec_',num2str(timepoints(gait_point)),'(n,1)=tibmusclevecs(n,1)*Imag(n)*weight_factor;'];
            eval(strx);
            stry=['tibtransmusvec_',num2str(timepoints(gait_point)),'(n,2)=tibmusclevecs(n,2)*Imag(n)*weight_factor;'];
            eval(stry);
            strz=['tibtransmusvec_',num2str(timepoints(gait_point)),'(n,3)=tibmusclevecs(n,3)*Imag(n)*weight_factor;'];
            eval(strz);
        end
        %
        str=['csvwrite(''muscleVecs_',num2str(timepoints(gait_point)),'.csv'',tibtransmusvec_',num2str(timepoints(gait_point)),')'];
        eval(str)
        %
    end
    disp(['Patient ', num2str(PatN),' complete.'])
end
%
clear Imag_15
clear Imag_28
clear Imag_44
clear Imag_63
clear Imag_96
clear Ivecs_15
clear Ivecs_28
clear Ivecs_44
clear Ivecs_63
clear Ivecs_96
clear timepoints
clear heights_cm_weights_kg
clear timepoints
clear trans
clear tibmusclevecs
clear str
clear strx
clear stry
clear strz
clear opensim_weight
clear IvecsMir
clear n
clear PatN
clear Imag
clear Ivecs
clear gait_point
clear DirName
clear BasePath
clear weight_factor
%
disp('Complete. See .csv files generated')